#include <stdio.h>
#include <stdlib.h>

typedef struct Frilenseri
{
    double a;
    double p;
}frilenser;

void swap(frilenser* a, frilenser* b){
    frilenser t = *a;
    *a = *b;
    *b = t;
}
double partition (frilenser arr[], int low, int high){
    double pivot = arr[high].p;
    int i = (low - 1);

    for (int j = low; j <= high- 1; j++)
    {
        if (arr[j].p > pivot)
        {
            i++;
            swap(&arr[i], &arr[j]);
        }
    }
    swap(&arr[i + 1], &arr[high]);
    return (i + 1);
}
void quickSort(frilenser arr[], int low, int high){
    if (low < high)
    {
        double pi = partition(arr, low, high);

        quickSort(arr, low, pi - 1);
        quickSort(arr, pi + 1, high);
    }
}

int main()
{
    int n;
    scanf("%d", &n);
    frilenser f[n];

    for(int i = 0; i < n; i++)
    {
        scanf("%lf", &f[i].a);
        scanf("%lf", &f[i].p);
    }
    quickSort(f, 0, n-1);
    double s = 0, z = 0;
    for(int i = 0; i < n; i++)
    {
        s += f[i].a;
        if(s * (f[i].p / 100) > z)
            z = s * (f[i].p / 100);
    }

    printf("%f", z);
    return 0;
}